(() => {
    "use strict";

    window.__lastRightClickDomain = "";

    const DOMAIN_REGEX = /\b((?:[a-z0-9-]+\.)+[a-z]{2,})\b/i;

    // 1) Normal pages: detect domain from link text / href / selection
    document.addEventListener(
        "contextmenu",
        (e) => {
            let domain = "";
            const link = e.target.closest("a");

            if (link && link.innerText) {
                const match = link.innerText.match(DOMAIN_REGEX);
                if (match && match[1]) domain = match[1];
            }

            if (!domain && link?.href) {
                try {
                    domain = new URL(link.href).hostname;
                } catch { }
            }

            if (!domain && window.getSelection) {
                const selectedText = window.getSelection().toString();
                const match = selectedText.match(DOMAIN_REGEX);
                if (match && match[1]) domain = match[1];
            }

            if (domain) window.__lastRightClickDomain = domain.replace(/^www\./, "");
        },
        true
    );

    // 2) Google Sheets: use selected cell text
    document.addEventListener(
        "contextmenu",
        () => {
            if (!location.href.includes("docs.google.com/spreadsheets")) return;

            const selection = window.getSelection();
            const selectedText = selection ? selection.toString().trim() : "";

            if (selectedText) {
                window.__lastRightClickDomain = selectedText.replace(/^www\./, "");
            }
        },
        true
    );
})();
